/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.ivw.demos.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.install.commons.flow.EventType;
import oracle.install.commons.flow.FlowContext;
import oracle.install.commons.flow.View;
import oracle.install.commons.flow.annotation.ViewDef;
import oracle.install.commons.swing.LayoutUtils;
import oracle.install.commons.swing.MultilineLabel;
import oracle.install.commons.swing.SortOrder;
import oracle.install.commons.swing.SortableTableModel;
import oracle.install.commons.swing.SwingUtils;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.ivw.demos.bean.DemosInstallSettings;
import oracle.install.ivw.demos.resource.DemosDialogLabelResID;
import oracle.install.library.util.InventoryInfo;

@ViewDef(id="NodeSelectionUI")
public class NodeSelectionUI
implements View {
    private NodeSelectionUITableModel tmSpreadTable;
    private JPanel gridInstallOptionsPanel;
    private JScrollPane spNodeTable;
    private MultilineLabel pageDesc;
    private Logger logger;
    private String m_pageDescPromptText;
    private String m_nodeNameTxt;
    private String[] strColHeader = new String[3];
    private JTable tblNodeDetails;

    public NodeSelectionUI() {
        this.logger = Logger.getLogger(NodeSelectionUI.class.getName());
        this.logger.log(Level.INFO, "NodeSelectionUI Entering Constructor");
        this.buildNodeTableUI();
    }

    public Component getView() {
        return this.gridInstallOptionsPanel;
    }

    public void localize(FlowContext arg0) {
        Resource resource = Application.getInstance().getResource(DemosDialogLabelResID.class.getName());
        this.m_pageDescPromptText = resource.getString("INSTALL_DEMOS_NODE_SELECTION_DLG_PROMPT", "Oracle Examples will be installed on following RAC nodes.", new Object[0]);
        this.m_nodeNameTxt = resource.getString("INSTALL_DEMOS_NODE_SELECTION_DLG_NODENAME_LABEL", "Node Name", new Object[0]);
        this.pageDesc.setText(this.m_pageDescPromptText);
        this.strColHeader[0] = " ";
        this.strColHeader[1] = " ";
        this.strColHeader[2] = this.m_nodeNameTxt;
        this.logger.info("strColHeader[0]:" + this.strColHeader[0]);
        this.logger.info("strColHeader[1]:" + this.strColHeader[1]);
        this.logger.info("strColHeader[2]:" + this.strColHeader[2]);
        this.setTableColumnNames();
    }

    public void onEvent(FlowContext flowContext, EventType event) {
        DemosInstallSettings demoBean = (DemosInstallSettings)((Object)flowContext.getBean(DemosInstallSettings.class));
        String home = demoBean.getOracleHome();
        if (event == EventType.INIT) {
            this.setdefaultValues(home);
        }
    }

    public void processInput(FlowContext flowContext) {
        DemosInstallSettings demosBean = (DemosInstallSettings)((Object)flowContext.getBean(DemosInstallSettings.class));
        switch (flowContext.getFlowDirection()) {
            case FORWARD: {
                break;
            }
            case BACKWARD: {
                demosBean.setListOfSelectedNodes(new String[0]);
            }
        }
    }

    private void setTableColumnNames() {
        TableColumnModel tcm = this.tblNodeDetails.getColumnModel();
        for (int iLoop = 0; iLoop < tcm.getColumnCount(); ++iLoop) {
            tcm.getColumn(iLoop).setHeaderValue(this.strColHeader[iLoop]);
        }
    }

    private void setdefaultValues(String home) {
        InventoryInfo invInfo = InventoryInfo.getInstance();
        String[] nodes = new String[1];
        nodes = invInfo.getNodeList(home).toArray(new String[0]);
        this.tmSpreadTable = new NodeSelectionUITableModel(nodes, this.strColHeader);
        if (nodes != null && nodes.length > 0) {
            this.tmSpreadTable.setSelectedNodes(nodes);
        }
        this.tblNodeDetails.setModel((TableModel)((Object)this.tmSpreadTable));
        this.tblNodeDetails.getTableHeader().setBorder(BorderFactory.createRaisedBevelBorder());
        TableColumn col = this.tblNodeDetails.getColumnModel().getColumn(0);
        col.setCellRenderer(new NodeSelectionUIRendererModel());
        col.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        col.setMaxWidth(20);
        col.setResizable(false);
        col = this.tblNodeDetails.getColumnModel().getColumn(1);
        col.setMaxWidth(20);
        col.setResizable(false);
        this.tblNodeDetails.setEnabled(true);
    }

    private void buildNodeTableUI() {
        this.pageDesc = new MultilineLabel();
        this.tblNodeDetails = new JTable();
        this.spNodeTable = new JScrollPane(this.tblNodeDetails);
        this.spNodeTable.getViewport().setBackground(this.tblNodeDetails.getBackground());
        this.gridInstallOptionsPanel = new JPanel();
        this.gridInstallOptionsPanel.setLayout(new GridBagLayout());
        LayoutUtils.addComponent((Component)this.pageDesc, (Container)this.gridInstallOptionsPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)18, (double)0.0, (double)0.0);
        LayoutUtils.addComponent((Component)this.spNodeTable, (Container)this.gridInstallOptionsPanel, (int)0, (int)1, (int)1, (int)1, (int)1, (int)18, (double)1.0, (double)1.0);
        this.tblNodeDetails.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblNodeDetails.getTableHeader().setReorderingAllowed(false);
        SwingUtils.setRowWiseFocusTraveralEnabled((JTable)this.tblNodeDetails, (boolean)true);
    }

    private class NodeSelectionUIRendererModel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        JCheckBox chkBxNodeSelection = new JCheckBox();

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            if (table == null || value == null) {
                return null;
            }
            this.chkBxNodeSelection.setSelected((Boolean)value);
            this.chkBxNodeSelection.setEnabled(table.getModel().isCellEditable(rowIndex, vColIndex));
            if (isSelected) {
                this.chkBxNodeSelection.setForeground(table.getSelectionForeground());
                this.chkBxNodeSelection.setBackground(table.getSelectionBackground());
            } else {
                this.chkBxNodeSelection.setForeground(table.getForeground());
                this.chkBxNodeSelection.setBackground(table.getBackground());
            }
            return this.chkBxNodeSelection;
        }
    }

    private class NodeSelectionUITableModel
    extends SortableTableModel {
        private static final long serialVersionUID = 1L;
        private String[] strData;
        private List<String> selectedNodes;
        private SortOrder[] columnSortOrder = new SortOrder[]{SortOrder.NONE, SortOrder.NONE, SortOrder.NONE};
        private String localNode;

        NodeSelectionUITableModel(String[] strData, String[] columnNames) {
            this.strData = strData;
            this.selectedNodes = new ArrayList<String>();
            this.setSelectedNodes(strData);
        }

        public List<String> getSelectedNodes() {
            return this.selectedNodes;
        }

        public void setSelectedNodes(String[] nodesList) {
            if (nodesList != null) {
                for (String node : nodesList) {
                    if (this.selectedNodes.contains(node)) continue;
                    this.selectedNodes.add(node);
                }
            }
        }

        public int getRowCount() {
            if (this.strData != null) {
                return this.strData.length;
            }
            return 0;
        }

        public int getColumnCount() {
            return 3;
        }

        public boolean isCellEditable(int iRow, int iCol) {
            return false;
        }

        public void setValueAt(Object aValue, int row, int column) {
            if (column == 0) {
                if (Boolean.valueOf(aValue.toString()).booleanValue() || this.strData[row].equals(this.localNode)) {
                    if (!this.selectedNodes.contains(this.strData[row])) {
                        this.selectedNodes.add(this.strData[row]);
                    }
                } else {
                    this.selectedNodes.remove(this.strData[row]);
                }
                super.fireTableCellUpdated(row, column);
            }
        }

        public Object getValueAt(int row, int col) {
            Object value = null;
            if (this.strData != null) {
                switch (col) {
                    case 0: {
                        String nodeName = this.strData[row];
                        value = this.selectedNodes.contains(nodeName);
                        break;
                    }
                    case 1: {
                        value = row + 1;
                        break;
                    }
                    case 2: {
                        value = this.strData[row];
                    }
                }
            }
            return value;
        }

        public void doSort(int colIndex, SortOrder sortOrder) {
            if (colIndex == 2) {
                if (sortOrder != SortOrder.ASCENDING) {
                    Arrays.sort(this.strData, Collections.reverseOrder());
                } else {
                    Arrays.sort(this.strData);
                }
                this.fireTableDataChanged();
            }
        }

        public SortOrder getColumnSortOrder(int colIndex) {
            if (colIndex < 0 || colIndex > 2) {
                return SortOrder.NONE;
            }
            return this.columnSortOrder[colIndex];
        }

        public void setColumnSortOrder(int colIndex, SortOrder sortOrder) {
            this.columnSortOrder[colIndex] = sortOrder;
        }
    }
}

